<?php
// Simple SMTP mailer wrapper.
// WARNING: Credentials are hard-coded by request. For production, use environment variables or a secrets store.

function send_smtp_mail($to, $subject, $body_html, $from_name = 'Checklist App', $from_email = 'no-reply@example.com'){
    // Hard-coded SMTP settings (replace with real credentials)
    $smtpHost = 'smtp.example.com';
    $smtpPort = 587; // or 465 for SSL
    $smtpUser = 'username@example.com';
    $smtpPass = 'supersecretpassword';
    $smtpSecure = 'tls'; // 'ssl' or 'tls' or ''

    // Build basic MIME headers
    $boundary = uniqid('np');
    $headers = [];
    $headers[] = 'From: ' . $from_name . ' <' . $from_email . '>';
    $headers[] = 'MIME-Version: 1.0';
    $headers[] = 'Content-Type: multipart/alternative;boundary=' . $boundary;

    $message = "--".$boundary."\r\n";
    $message .= "Content-Type: text/plain; charset=utf-8\r\n\r\n";
    $message .= strip_tags($body_html) . "\r\n\r\n";
    $message .= "--".$boundary."\r\n";
    $message .= "Content-Type: text/html; charset=utf-8\r\n\r\n";
    $message .= $body_html . "\r\n\r\n";
    $message .= "--".$boundary."--";

    // Try using mail() as a fallback (if the system MTA is configured)
    // But prefer SMTP via stream_socket_client if available for explicit control.
    // For simplicity, attempt mail() first, then fall back to a minimal SMTP socket if mail() fails.
    $headersStr = implode("\r\n", $headers);
    $mailOk = @mail($to, $subject, $message, $headersStr);
    if ($mailOk) return [true, 'sent-via-mail'];

    // Minimal SMTP client (very small, not fully featured) - attempt STARTTLS if requested.
    $remote = ($smtpSecure === 'ssl') ? 'ssl://' . $smtpHost : $smtpHost;
    $errno = 0; $errstr = '';
    $timeout = 15;
    $fp = @stream_socket_client($remote . ':' . $smtpPort, $errno, $errstr, $timeout, STREAM_CLIENT_CONNECT);
    if (!$fp) return [false, "smtp_connect_failed: $errno $errstr"];

    // Basic SMTP dialog helper
    $read = function() use ($fp){ $res = ''; while (($line = fgets($fp, 515)) !== false){ $res .= $line; if (substr($line,3,1) === ' ') break; } return $res; };
    $write = function($cmd) use ($fp){ fwrite($fp, $cmd . "\r\n"); };

    $greeting = $read();
    if (strpos($greeting, '220') !== 0) { fclose($fp); return [false, 'smtp_greeting_failed: ' . trim($greeting)]; }

    $write('EHLO ' . gethostname()); $res = $read();
    if ($smtpSecure === 'tls'){
        $write('STARTTLS'); $res = $read();
        if (strpos($res, '220') !== 0){ fclose($fp); return [false, 'starttls_failed: ' . trim($res)]; }
        // enable crypto
        if (!stream_socket_enable_crypto($fp, true, STREAM_CRYPTO_METHOD_TLS_CLIENT)){
            fclose($fp); return [false, 'tls_crypto_failed'];
        }
        // EHLO again
        $write('EHLO ' . gethostname()); $res = $read();
    }

    // AUTH LOGIN
    $write('AUTH LOGIN'); $res = $read();
    if (strpos($res, '334') !== 0){ fclose($fp); return [false, 'auth_not_supported: ' . trim($res)]; }
    $write(base64_encode($smtpUser)); $res = $read();
    $write(base64_encode($smtpPass)); $res = $read();
    if (strpos($res, '235') !== 0){ fclose($fp); return [false, 'auth_failed: ' . trim($res)]; }

    $write('MAIL FROM: <' . $from_email . '>'); $res = $read(); if (strpos($res, '250') !== 0){ fclose($fp); return [false, 'mailfrom_failed: ' . trim($res)]; }
    $write('RCPT TO: <' . $to . '>'); $res = $read(); if (!(strpos($res, '250') === 0 || strpos($res, '251') === 0)){ fclose($fp); return [false, 'rcptto_failed: ' . trim($res)]; }
    $write('DATA'); $res = $read(); if (strpos($res, '354') !== 0){ fclose($fp); return [false, 'data_failed: ' . trim($res)]; }

    // send headers + body
    $raw = "From: $from_name <$from_email>\r\n";
    $raw .= "To: $to\r\n";
    $raw .= "Subject: $subject\r\n";
    $raw .= $headersStr . "\r\n\r\n" . $message . "\r\n.\r\n";
    $write($raw);
    $res = $read();
    if (strpos($res, '250') !== 0){ fclose($fp); return [false, 'send_failed: ' . trim($res)]; }

    $write('QUIT'); $read(); fclose($fp);
    return [true, 'sent-via-smtp'];
}

function send_invite_email($toEmail, $inviteLink, $opts = []){
    $fromName = $opts['from_name'] ?? 'Checklist Admin';
    $fromEmail = $opts['from_email'] ?? 'no-reply@example.com';
    $subject = $opts['subject'] ?? 'You were invited to join Checklist';
    $body = '<p>Hello,</p>';
    $body .= '<p>You have been invited to join Checklist. Click the link below to register (link expires):</p>';
    $body .= '<p><a href="' . htmlspecialchars($inviteLink) . '">' . htmlspecialchars($inviteLink) . '</a></p>';
    $body .= '<p>If you did not expect this, ignore this email.</p>';
    $body .= '<p>— Checklist</p>';

    return send_smtp_mail($toEmail, $subject, $body, $fromName, $fromEmail);
}
